// /////////////////////////////////////////////////////////////////////////////
// DR DOBB'S CHALLENGES
//
// Filename       : EntityTokenCollector.cpp
// Date           : February 2008
//
// Description    : Refer to description in corresponding header.
//
// ///////////////////////////////////////////////////////////////////////////


#include "EntityTokenCollector.h"
#include "Level.h"
#include "Application.h"




EntityTokenCollector::EntityTokenCollector() :
  m_TokensNeeded( 0 )
{

  SetRect( &m_CollisionRect, 0, 0, 64, 64 );

  SetFrame( Dobbs::ANIM_TOKEN_COLLECTOR );

  m_Floating = true;

}



EntityTokenCollector::~EntityTokenCollector() 
{
}



void EntityTokenCollector::OnEvent( const EntityEvent Event, int Param1, int Param2, const std::string& TextParam, Entity* pEntity )
{

  switch ( Event )
  {
    case EE_INIT:
      m_TokensNeeded = m_ExtraData;
      break;
    case EE_DROP:
      break;
  }
  Entity::OnEvent( Event, Param1, Param2, TextParam, pEntity );

}



void EntityTokenCollector::UpdateTimed( Level& aLevel, float ElapsedTime )
{

  Entity::UpdateTimed( aLevel, ElapsedTime );

}



void EntityTokenCollector::Render( int XOffset, int YOffset )
{

  Entity::Render( XOffset, YOffset );

  if ( m_TokensNeeded != 0 )
  {
    // Force draw so the number is displayed in the correct z order
    g_App.RenderBatchedTiles();
    char    Temp[200];

    wsprintfA( Temp, "%d", m_TokensNeeded );
    g_App.RenderTextCentered( "GUI.Small", Temp, m_X - XOffset + 31, m_Y - YOffset + 20, 0xff5fff00 );

    g_App.ForceSpriteDraw();
  }

}